Ext.data.JsonP.sol_common_ix_services_GetTemplates_Provider({"tagname":"class","name":"sol.common.ix.services.GetTemplates.Provider","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"sol.common.ix.services.GetTemplates.js","href":"sol.common.ix.services.GetTemplates.html#sol-common-ix-services-GetTemplates-Provider"}],"protected":true,"requires":["sol.common.IxUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"cache","tagname":"property","owner":"sol.common.ix.services.GetTemplates.Provider","id":"property-cache","meta":{"private":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"getConfigHierarchy","tagname":"method","owner":"sol.common.ix.services.GetTemplates.Provider","id":"method-getConfigHierarchy","meta":{"private":true}},{"name":"getRelatedFolderIds","tagname":"method","owner":"sol.common.ix.services.GetTemplates.Provider","id":"method-getRelatedFolderIds","meta":{}},{"name":"idsToString","tagname":"method","owner":"sol.common.ix.services.GetTemplates.Provider","id":"method-idsToString","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"retrieveFolderIds","tagname":"method","owner":"sol.common.ix.services.GetTemplates.Provider","id":"method-retrieveFolderIds","meta":{"private":true}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.ix.services.GetTemplates.Provider","short_doc":"Internal cache for the folder IDs used to determine related templates. ...","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.services.GetTemplates.Provider</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.IxUtils' rel='sol.common.IxUtils' class='docClass'>sol.common.IxUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/sol.common.ix.services.GetTemplates.html#sol-common-ix-services-GetTemplates-Provider' target='_blank'>sol.common.ix.services.GetTemplates.js</a></div></pre><div class='doc-contents'><p>Internal cache for the folder IDs used to determine related templates.</p>\n\n<p>Uses the merge hierarchy like the configuration does.</p>\n\n<p>This should be uses only by <a href=\"#!/api/sol.common.ix.services.GetTemplates\" rel=\"sol.common.ix.services.GetTemplates\" class=\"docClass\">GetTemplates</a>.</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-cache' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetTemplates.Provider'>sol.common.ix.services.GetTemplates.Provider</span><br/><a href='source/sol.common.ix.services.GetTemplates.html#sol-common-ix-services-GetTemplates-Provider-property-cache' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetTemplates.Provider-property-cache' class='name expandable'>cache</a> : Array<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>[]</code></p></div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-getConfigHierarchy' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetTemplates.Provider'>sol.common.ix.services.GetTemplates.Provider</span><br/><a href='source/sol.common.ix.services.GetTemplates.html#sol-common-ix-services-GetTemplates-Provider-method-getConfigHierarchy' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetTemplates.Provider-method-getConfigHierarchy' class='name expandable'>getConfigHierarchy</a>( <span class='pre'>originObjId</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>originObjId</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getRelatedFolderIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetTemplates.Provider'>sol.common.ix.services.GetTemplates.Provider</span><br/><a href='source/sol.common.ix.services.GetTemplates.html#sol-common-ix-services-GetTemplates-Provider-method-getRelatedFolderIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetTemplates.Provider-method-getRelatedFolderIds' class='name expandable'>getRelatedFolderIds</a>( <span class='pre'>originObjId</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Read the folder IDs of all folders belonging to a specified one. ...</div><div class='long'><p>Read the folder IDs of all folders belonging to a specified one.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>originObjId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>A comma separated list of all related objIds</p>\n</div></li></ul></div></div></div><div id='method-idsToString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetTemplates.Provider'>sol.common.ix.services.GetTemplates.Provider</span><br/><a href='source/sol.common.ix.services.GetTemplates.html#sol-common-ix-services-GetTemplates-Provider-method-idsToString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetTemplates.Provider-method-idsToString' class='name expandable'>idsToString</a>( <span class='pre'>parentIds</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts an Array of objIds to an String for the SQL query. ...</div><div class='long'><p>Converts an Array of objIds to an String for the SQL query.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>parentIds</span> : String[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-retrieveFolderIds' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.services.GetTemplates.Provider'>sol.common.ix.services.GetTemplates.Provider</span><br/><a href='source/sol.common.ix.services.GetTemplates.html#sol-common-ix-services-GetTemplates-Provider-method-retrieveFolderIds' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.services.GetTemplates.Provider-method-retrieveFolderIds' class='name expandable'>retrieveFolderIds</a>( <span class='pre'>originObjId</span> ) : String[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Retrieves the folder IDs. ...</div><div class='long'><p>Retrieves the folder IDs.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>originObjId</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'><p>A comma list of all related objIds</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"protected":true,"singleton":true}});